\name{msm}
\alias{msm}
\title{Marginal structural model from the parametric g-formula for continuous multiple time point interventions}

\description{Estimation of a marginal structural model using the parametric g-formula.}
\usage{
msm(X, formula, family = gaussian, se = NULL, cilevel = 0.95, abar=NULL)
}

\arguments{
  \item{X}{
An object of class \code{gformula} produced by \code{\link{gformula}}, with option \code{ret = TRUE}. 
}
  \item{formula}{
Form of the marginal structural model. Can be specified as a formula object, e.g., \code{formula = VL.4 ~ efv.4}, as a quoted expression, e.g., \code{formula = quote(VL.4 ~ efv.4)}, or as a character string, e.g., \code{formula = "VL.4 ~ efv.4"}.
}
  \item{family}{
A description of the error distribution and link function to be used in the model. See \code{\link[stats]{family}}  for details of family functions.
}
  \item{se}{
A character string specifying the standard errors used to compute confidence intervals. One of \code{c('bootstrap', 'glm')}. See Details.
}
  \item{cilevel}{
Numeric value between 0 and 1 specifying the confidence level of the bootstrap confidence intervals. Defaults to 95\%. 
}
\item{abar}{
Vector or matrix that is a subset of the intervention used in X. Can be used to fit an MSM on a subset of the stacked counterfactual data.
}
}

\details{
    The marginal structural model (MSM) is estimated as a GLM. Confidence intervals are calculated using GLM standard errors (if \code{se = 'glm'}) or nonparametric boostrap standard errors (if \code{se = 'bootstrap'} and \code{gformula} was run with \code{B > 0}.) By default: \code{se = 'bootstrap'} if \code{gformula} was run with \code{B > 0}, and \code{se = 'glm'} otherwise.
}

\value{
Returns a list of class \code{msmResult}:
  \item{MSM}{The fitted MSM of class \code{glm}.}
  \item{coefs}{The estimated coefficients of the MSM.}
  \item{CIlow}{Lower confidence interval bounds for each coefficient.}
  \item{CIup}{Upper confidence interval bounds for each coefficient.}
  \item{formula}{The 'formula' input argument.}
  \item{se}{The 'se' input argument.}
  \item{vcov}{Covariance matrix.}
}

\seealso{\code{\link{gformula}} for estimating expected counterfactual outcomes under multiple intervention values.}

\examples{
\donttest{
data(EFV)
gf <- gformula(
  X = EFV, Anodes = c("efv.0", "efv.1", "efv.2", "efv.3", "efv.4"),
  Ynodes = c("VL.0", "VL.1", "VL.2", "VL.3", "VL.4"),
  Lnodes = c("adherence.1", "weight.1", "adherence.2", "weight.2",
             "adherence.3", "weight.3", "adherence.4", "weight.4"),
  abar = seq(0, 5), B = 10, ret = TRUE
)

msm(gf, VL.4 ~ efv.4, se = "bootstrap") # default if B>0
msm(gf, VL.4 ~ efv.4, se = "glm")       # fast, but not valid (undercoverage)
}
}