#' Yoghurt Dataset
#'
#' A dataset containing experimental or survey data related to yogurt.
#'
#' @format A data frame with the following columns:
#' \describe{
#'   \item{adult}{Description of adult variable}
#'   \item{fadult}{Description of fadult variable} 
#'   \item{left}{Description of left variable}
#'   \item{right}{Description of right variable}
#' }
#'
#' @details 
#' This dataset contains experimental data collected from yogurt-related studies.
#' The specific meaning of each variable should be documented based on the original study.
#'
#' @examples
#' # Load the data
#' data(yoghurt)
#' 
#' # Examine data structure
#' str(yoghurt)
#' 
#' # View first few rows
#' head(yoghurt)
#' 
#' # Basic summary statistics
#' summary(yoghurt)
#'
#' @source 
#' Original data source should be specified here.
#'
#' @docType data
#' @keywords datasets
#' @name yoghurt
#' @usage data(yoghurt)
NULL
