% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_independence_test.R
\name{perform_independence_test}
\alias{perform_independence_test}
\title{Perform a hypothesis test of independence}
\usage{
perform_independence_test(
  X1,
  X2,
  my_grid = NULL,
  nBootstrap = 100,
  show_progress = TRUE,
  bootstrapOptions = NULL
)
}
\arguments{
\item{X1, X2}{numerical vectors of the same size. The independence test tests
whether \code{X1} is independent from \code{X2}.}

\item{my_grid}{the grid on which the CDFs are estimated. This must be one of
\itemize{
  \item \code{NULL}: a regularly spaced grid from the minimum value to the
  maximum value of each variable with \code{20} points is used. This is the
  default.

  \item A numeric of size 1. This is used at the length of both grids, replacing
  \code{20} in the above explanation.

  \item A numeric vector of size larger than 1. This is directly used as the
  grid for both variables.

  \item A list of two numeric vectors, which are used as the grids for both
  variables \code{X1} and \code{X2} respectively.
}}

\item{nBootstrap}{number of bootstrap repetitions.}

\item{show_progress}{logical value indicating whether to show a progress bar}

\item{bootstrapOptions}{This can be one of \itemize{
  \item \code{NULL} This uses the default options \code{type_boot = "indep"},
  \code{type_stat = "eq"} and \code{type_norm = "KS"}.

  \item a list with at most 3 elements names \itemize{
        \item \code{type_boot} type of bootstrap resampling scheme. It must be
        one of
        \itemize{
           \item \code{"indep"} for the independence bootstrap
           (i.e. under the null). This is the default.
           \item \code{"NP"} for the non-parametric bootstrap
           (i.e. n out of n bootstrap).
        }

        \item \code{type_stat}  type of test statistic to be used.  It must be
        one of
        \itemize{
          \item \code{"eq"} for the equivalent test statistic
          \deqn{T_n^* = \sqrt{n} || \hat{F}_{(X,Y)}^* - \hat{F}_{X}^* \hat{F}_{Y}^* ||}

          \item \code{"cent"} for the centered test statistic
          \deqn{T_n^* = \sqrt{n} || \hat{F}_{(X,Y)}^* - \hat{F}_{X}^* \hat{F}_{Y}^*
          -  (\hat{F}_{(X,Y)} - \hat{F}_{X} \hat{F}_{Y}) ||}
        }
        For each \code{type_boot} there is only one valid choice of \code{type_stat}
        to be made. If \code{type_stat} is not specified, the valid choice is
        automatically used.

        \item \code{type_norm} type of norm to be used for the test statistic.
         It must be one of
        \itemize{
           \item \code{"KS"} for the Kolmogorov-Smirnov type test statistic.
           This is the default. It is given as
           \deqn{
               T_n = \sqrt{n} \sup_{(x, y) \in \mathbb{R}\rule{0pt}{0.6em}^{p+q}}
               \big| \hat{F}_{(X,Y),n}(x , y) - \hat{F}_{X,n}(x) \hat{F}_{Y,n}(y)
               \big|
               }
           \item \code{"L2"} for the squared L2-norm test statistic.
           \deqn{ T_n = \sqrt{n}\int_{(x, y) \in
                 \mathbb{R}\rule{0pt}{0.6em}^{p+q}}
                 \big( \hat{F}_{(X,Y),n}(x , y) -
                 \hat{F}_{X,n}(x) \hat{F}_{Y,n}(y) \big)^2
                 \mathrm{d}x\mathrm{d}y
               }
        }
  }

  \item \code{"all"} this gives test results for all theoretically valid
  combinations of bootstrap resampling schemes.

  \item \code{"all and also invalid"} this gives test results for all possible
  combinations of bootstrap resampling schemes and test statistics, including
  invalid ones.
}
A warning is raised if the given combination of \code{type_boot_user} and
\code{type_stat_user} is theoretically invalid.}
}
\value{
A class object with components \itemize{
   \item \code{pvals_df}: a dataframe of p-values and bootstrapped test statistics:

   These are the p-values for the 8 combinations of bootstrap resampling schemes
   (nonparametric and independent), test statistics (centered and equivalent),
   and Kolmogorov-Smirnov or L2-type of true test statistic.

   It also contains the vectors of bootstrap test statistics
   for each of the combinations.

   \item \code{true_stats} a named vector of size 2 containing the true test
   statistics for the L2 and KS distances.

   \item \code{nBootstrap} Number of bootstrap repetitions.

   \item \code{nameMethod} string for the name of the method used.
}
}
\description{
Perform a hypothesis test of statistical independence by means of bootstrapping.
The null hypothesis is that of independence between the two random variables,
versus the alternative of dependence between them.
This procedure gives a total of 8 combinations of bootstrap resampling schemes
(nonparametric and independent), test statistics (centered and equivalent),
and Kolmogorov-Smirnov or L2-type of true test statistic. This function
gives the corresponding p-values, the true test statistic and the
bootstrap-version test statistics. The default (and valid) method implemented
in this function is the null bootstrap, together with the equivalent test
statistic and Kolmogorov-Smirnov test statistic.
Via the \code{bootstrapOptions} argument, the user can specify other
bootstrap resampling schemes and test statistics.
}
\examples{
n <- 100

# Under H1
X1 <- rnorm(n)
X2 <- X1 + rnorm(n)
result <- perform_independence_test(
   X1, X2, nBootstrap = 50,
   bootstrapOptions = list(type_boot = "indep",
                           type_stat = "eq",
                           type_norm = "KS") )
print(result)
plot(result)

# Under H0
X1 <- rnorm(n)
X2 <- rnorm(n)
result <- perform_independence_test(X1, X2, nBootstrap = 50)
print(result)
plot(result)

}
\references{
Derumigny, A., Galanis, M., Schipper, W., & van der Vaart, A. (2025).
Bootstrapping not under the null?
ArXiv preprint, \doi{10.48550/arXiv.2512.10546}
}
\seealso{
\code{\link{perform_GoF_test},\link{perform_regression_test}}.
The print and plot methods, such as \code{\link{plot.bootstrapTest}}.
}
