% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonBayesian_based.R
\name{classify_with_scores}
\alias{classify_with_scores}
\title{Classification based on a thresholding of the scores}
\usage{
classify_with_scores(scores, vL, vU)
}
\arguments{
\item{scores}{Numeric vector of the scores, computed with
\link{average_scoring}, \link{median_scoring}, \link{MAP_scoring} or \link{bayesian_scoring}}

\item{vL}{The lower threshold}

\item{vU}{The upper threshold}
}
\value{
A numeric vector of the classification (where 0.5 = inconclusive)
}
\description{
Classification based on a thresholding of the scores
}
\details{
Each decision \eqn{\hat{t}_i} is taken according to the following rule:
\deqn{
        \hat{t}_i = \begin{cases}
         0 & \text{if } y_i < v_L,\\
         1/2 & \text{if } v_L \leq y_i \leq v_U,\\
         1 & \text{if } y_i > v_U,
         \end{cases}
}
where \eqn{y_i} is the score for individual \eqn{i}.
}
