% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdBind_hdf5_datasets}
\alias{bdBind_hdf5_datasets}
\title{Bind matrices by rows or columns}
\usage{
bdBind_hdf5_datasets(
  filename,
  group,
  datasets,
  outgroup,
  outdataset,
  func,
  overwrite = FALSE
)
}
\arguments{
\item{filename}{Character array indicating the name of the file to create}

\item{group}{Character array indicating the input group containing the datasets}

\item{datasets}{Character array specifying the input datasets to bind}

\item{outgroup}{Character array indicating the output group for the merged dataset.
If NULL, output is stored in the same input group}

\item{outdataset}{Character array specifying the name for the new merged dataset}

\item{func}{Character array specifying the binding operation:
- "bindRows": Merge datasets by rows (vertical stacking)
- "bindCols": Merge datasets by columns (horizontal joining)
- "bindRowsbyIndex": Merge datasets by rows using an index}

\item{overwrite}{Boolean indicating whether to overwrite existing datasets.
Defaults to false}
}
\value{
A list containing the location of the combined dataset:
\describe{
\item{fn}{Character string. Path to the HDF5 file containing the result}
\item{ds}{Character string. Full dataset path to the bound/combined dataset within the HDF5 file}
}
}
\description{
This function merges existing matrices within an HDF5 data file either by
combining their rows (stacking vertically) or columns (joining horizontally).
It provides functionality similar to R's rbind and cbind operations.
}
\details{
The function performs dimension validation before binding:
\itemize{
\item For row binding: All datasets must have the same number of columns
\item For column binding: All datasets must have the same number of rows
}

Memory efficiency is achieved through:
\itemize{
\item Block-wise reading and writing
\item Minimal data copying
\item Proper resource cleanup
}
}
\note{
When binding by rows with an index, the index determines the
order of combination
}
\examples{
\dontrun{
library(BigDataStatMeth)

# Create test matrices
a <- matrix(1:12, 4, 3)
b <- matrix(13:24, 4, 3)

# Save to HDF5
bdCreate_hdf5_matrix("test.hdf5", a, "data", "A")
bdCreate_hdf5_matrix("test.hdf5", b, "data", "B")

# Bind by rows
bdBind_hdf5_datasets("test.hdf5", "data", 
                     c("A", "B"),
                     "results", "combined",
                     "bindRows")
}

}
