% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acceptance_ratio.R
\name{get_acceptance_ratios}
\alias{get_acceptance_ratios}
\alias{get_acceptance_ratios.BayesMallows}
\alias{get_acceptance_ratios.SMCMallows}
\title{Get Acceptance Ratios}
\usage{
get_acceptance_ratios(model_fit, ...)

\method{get_acceptance_ratios}{BayesMallows}(model_fit, ...)

\method{get_acceptance_ratios}{SMCMallows}(model_fit, ...)
}
\arguments{
\item{model_fit}{A model fit.}

\item{...}{Other arguments passed on to other methods. Currently not used.}
}
\description{
Extract acceptance ratio from Metropolis-Hastings
algorithm used by \code{\link[=compute_mallows]{compute_mallows()}} or by the move step in
\code{\link[=update_mallows]{update_mallows()}} and \code{\link[=compute_mallows_sequentially]{compute_mallows_sequentially()}}. Currently the
function only returns the values, but it will be refined in the future. If
burnin is not set in the call to \code{\link[=compute_mallows]{compute_mallows()}}, the acceptance ratio
for all iterations will be reported. Otherwise the post burnin acceptance
ratio is reported. For the SMC method the acceptance ratios apply to all
iterations, since no burnin is needed in here.
}
\examples{
set.seed(1)
mod <- compute_mallows(
  data = setup_rank_data(potato_visual),
  compute_options = set_compute_options(burnin = 200)
)

get_acceptance_ratios(mod)
}
\seealso{
Other posterior quantities: 
\code{\link{assign_cluster}()},
\code{\link{compute_consensus}()},
\code{\link{compute_posterior_intervals}()},
\code{\link{heat_plot}()},
\code{\link{plot.BayesMallows}()},
\code{\link{plot.SMCMallows}()},
\code{\link{plot_elbow}()},
\code{\link{plot_top_k}()},
\code{\link{predict_top_k}()},
\code{\link{print.BayesMallows}()}
}
\concept{posterior quantities}
