% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdeconv.R
\name{bdeconv}
\alias{bdeconv}
\title{Obtaining MCMC samples from deconvoluted density}
\usage{
bdeconv(
  obj,
  lwr = 0,
  upr = NULL,
  wgts = NULL,
  regular_var = NULL,
  res_type = c("final", "mean", "all"),
  err_type = c("flex", "norm", "lapl"),
  var_type = c("heteroscedastic", "homoscedastic"),
  na_rm = FALSE,
  control = list(),
  progress = FALSE,
  core_num = 1,
  parallel = FALSE
)
}
\arguments{
\item{obj}{A data frame where the first column is subject labels.}

\item{lwr}{Unused.}

\item{upr}{The ratio of an upper bound for the deconvolved estimates to the upper bound of the surrogates. It can be either a
scalar or a vector with a length that matches the number of numeric columns
in \code{obj}.}

\item{wgts}{Unused.}

\item{regular_var}{Specifies which variables to consider as regular; all others are treated as zero inflated.}

\item{res_type}{The type of result returned from the MCMC sampler.}

\item{err_type}{The shape of the error distribution used for deconvolution.}

\item{var_type}{whether to use homogeneous or heterogeneous error distribution.}

\item{na_rm}{A logical value indicating whether to ignore rows which contain
\code{NA} values in numeric columns.}

\item{control}{A list of arguments specifying prior hyper-parameters and parameters of the MCMC sampler.}

\item{progress}{Whether a progress bar for MCMC will be shown or not.  Default is FALSE.}

\item{core_num}{If parallelized, number of cores to be used.}

\item{parallel}{For multivariate data. Whether the pre-processing of each variable will be parallelized or not. Default is FALSE.}
}
\value{
A \code{bdeconv_result} object, containing all the posterior samples, suitable for further analysis and visualization.
}
\description{
Obtaining MCMC samples from deconvoluted density
}
\details{
All hyper-parameters of the model and variables necessary for the MCMC sampler can be specified through a list via the control argument; some of the most important ones are listed.
\itemize{
\item \code{nsamp}: Number of finally retained MCMC samples after burn-in and thinning. Default is 1000.
\item \code{nburn}: Burn-in period. Default is 2000.
\item \code{nthin}: Thinning interval. Default is 5.
\item \code{niter_uni}: For multivariate data, number of iteration for pre-processing of each variable. Default is 500.
\item \code{K_t}: Number of knot points for bspline. Default is 10.
\item \code{K_x}: Number of mixture components in the model for the density of X when the surrogates are strictly continuous. Not applicable when the surrogates are zero-inflated in which case the density is modeled using normalized bsplines. Default is 10.
\item \code{K_epsilon}: Number of mixture components in the model for the density of scaled errors when applicable. Default is 10.
\item \code{sigmasq_epsilon}: variance parameter for the normal prior of the scaled error mixture components' location parameter. Default is 4.
\item \code{a_epsilon}: shape parameter for the inverse gamma prior of the variances of scaled error mixture components. Default is 3.
\item \code{b_epsilon}: rate parameter for the inverse gamma prior of the variances of scaled error mixture components. Default is 2.
\item \code{a_vartheta}: shape parameter for the inverse gamma prior of the variances of bspline coefficients corresponding to the variance function. Default is 100.
\item \code{b_vartheta}: rate parameter for the inverse gamma prior of the variances of bspline coefficients corresponding to the variance function. Default is 1.
\item \code{a_xi}: shape parameter for the inverse gamma prior of the variances of bspline coefficients corresponding to the densities of episodic components. Default is 100.
\item \code{b_xi}: rate parameter for the inverse gamma prior of the variances of bspline coefficients corresponding to the densities of episodic components. Default is 10.
\item \code{a_beta}: shape parameter for the inverse gamma prior of the variances of bspline coefficients corresponding to the probability of consumption function. Default is 100.
\item \code{b_beta}: rate parameter for the inverse gamma prior of the variances of bspline coefficients corresponding to the probability of consumption function. Default is 1.
}
}
\examples{
data(BayesDecon_data_simulated)
set.seed(123)
### Selecting first 300 rows for demonstration.
### For best results, using the whole data is recommended.
result_uni <- bdeconv(BayesDecon_data_simulated[1:300,c(1,2)],
 upr = 1, res_type = "all",
 control = list(nsamp = 500, nburn = 0, nthin = 1),
 progress = TRUE)
plot(result_uni)

\donttest{
set.seed(123)
result_mult <- bdeconv(BayesDecon_data_simulated, upr = 1, res_type = "all", progress = TRUE)
plot(result_mult)
plot(result_mult[,c(1,2)])
value = rbind(c(1,1,1),c(2,2,2),c(3,3,3),c(4,4,4))
colMeans(dist_x(result_mult, vals = value))
colMeans(dens_x(result_mult, vals = value))
print(result_mult)
}

}
