context('ModuleHelp')

directory <- tempdir()

test_that('ModuleHelp errors', {
  
  if (!capabilities('libcurl')) skip('skipping as libcurl not supported')  
  
  expect_error(ModuleHelp(c(one, two)),
               "module must be a character of length 1")
  
  expect_error(ModuleHelp('NoProce1s'),
               "Can't find 'NoProce1s'. Did you mean")
  
  org <- getOption('help_type')
  options(help_type = 'text')
  
  capture.output(ModuleHelp('NoProcess'),
                 file = file.path(directory, 'help.txt'))
  
  expect_true(file.exists(file.path(directory, 'help.txt')))
  unlink(x = file.path(directory, 'help.txt'))
  
  options(help_type = org)
  
})