% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind.R
\name{rbind.zoocat}
\alias{rbind.zoocat}
\title{Merge two or more \code{zoocat} objects by rows}
\usage{
rbind.zoocat(..., deparse.levels = 1)
}
\arguments{
\item{...}{\code{zoocat} objects.}

\item{deparse.levels}{Not used.}
}
\description{
Merge two or more \code{zoocat} objects by rows. Note that all the \code{cattr} tables
must be the same.
}
\examples{
x <- matrix(1 : 20, nrow = 5)
colAttr <- data.frame(month = c(2, 3, 5, 6), name = c(rep('xxx', 3), 'yyy'))
zc <- zoocat(x, order.by = 1991 : 1995, colattr = colAttr) 
zc2 <- zc
index(zc2) <- index(zc) + 6
rbind(zc, zc2)

}

