# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Create a new compressor object
#'
#' Initialize a new compressor object for zlib-based compression with specified settings.
#' @param level Compression level, integer between 0 and 9, or -1 for default.
#' @param method Compression method.
#' @param wbits Window size bits.
#' @param memLevel Memory level for internal compression state.
#' @param strategy Compression strategy.
#' @param zdict Optional predefined compression dictionary as a raw vector.
#' @return A SEXP pointer to the new compressor object.
#' @examples
#' compressor <- create_compressor(level = 6, memLevel = 8)
#' @export
create_compressor <- function(level = -1L, method = 8L, wbits = 15L, memLevel = 8L, strategy = 0L, zdict = NULL) {
    .Call(`_zlib_create_compressor`, level, method, wbits, memLevel, strategy, zdict)
}

#' @title Compress a Chunk of Data
#'
#' @description Compresses a given chunk of raw binary data using a pre-existing compressor object.
#'
#' @param compressorPtr An external pointer to an existing compressor object.
#' This object is usually initialized by calling a different function like `create_compressor()`.
#'
#' @param input_chunk A raw vector containing the uncompressed data that needs to be compressed.
#'
#' @return A raw vector containing the compressed data.
#'
#' @details
#' This function is primarily designed for use with a compressor object created by `create_compressor()`.
#' It takes a chunk of raw data and compresses it, returning a raw vector of the compressed data.
#'
#' @examples
#' # Create a new compressor object for zlib -> wbts = 15
#' zlib_compressor <- create_compressor(wbits=31)
#' compressed_data <- compress_chunk(zlib_compressor, charToRaw("Hello, World"))
#' compressed_data <- c(compressed_data, flush_compressor_buffer(zlib_compressor))
#' decompressed_data <- memDecompress(compressed_data, type = "gzip")
#' cat(rawToChar(decompressed_data))
#' @export
compress_chunk <- function(compressorPtr, input_chunk) {
    .Call(`_zlib_compress_chunk`, compressorPtr, input_chunk)
}

#' Flush the internal buffer of the compressor object.
#'
#' This function flushes the internal buffer according to the specified mode.
#' @param compressorPtr A SEXP pointer to an existing compressor object.
#' @param mode A compression flush mode. Default is Z_FINISH.
#'     Available modes are Z_NO_FLUSH, Z_PARTIAL_FLUSH, Z_SYNC_FLUSH, Z_FULL_FLUSH, Z_BLOCK, and Z_FINISH.
#' @return A raw vector containing the flushed output.
#' @examples
#' compressor <- create_compressor()
#' # ... (some compression actions)
#' flushed_data <- flush_compressor_buffer(compressor)
#' @export
flush_compressor_buffer <- function(compressorPtr, mode = 4L) {
    .Call(`_zlib_flush_compressor_buffer`, compressorPtr, mode)
}

#' Retrieve zlib Constants
#'
#' This function returns a list of constants from the zlib C library.
#'
#' The constants are defined as follows:
#' \itemize{
#'   \item \code{DEFLATED}: The compression method, set to 8.
#'   \item \code{DEF_BUF_SIZE}: The default buffer size, set to 16384.
#'   \item \code{DEF_MEM_LEVEL}: Default memory level, set to 8.
#'   \item \code{MAX_WBITS}: Maximum size of the history buffer, set to 15.
#'   \item \code{Z_BEST_COMPRESSION}: Best compression level, set to 9.
#'   \item \code{Z_BEST_SPEED}: Best speed for compression, set to 1.
#'   \item \code{Z_BLOCK}: Block compression mode, set to 5.
#'   \item \code{Z_DEFAULT_COMPRESSION}: Default compression level, set to -1.
#'   \item \code{Z_DEFAULT_STRATEGY}: Default compression strategy, set to 0.
#'   \item \code{Z_FILTERED}: Filtered compression mode, set to 1.
#'   \item \code{Z_FINISH}: Finish compression mode, set to 4.
#'   \item \code{Z_FULL_FLUSH}: Full flush mode, set to 3.
#'   \item \code{Z_HUFFMAN_ONLY}: Huffman-only compression mode, set to 2.
#'   \item \code{Z_NO_COMPRESSION}: No compression, set to 0.
#'   \item \code{Z_NO_FLUSH}: No flush mode, set to 0.
#'   \item \code{Z_PARTIAL_FLUSH}: Partial flush mode, set to 1.
#'   \item \code{Z_RLE}: Run-length encoding compression mode, set to 3.
#'   \item \code{Z_SYNC_FLUSH}: Synchronized flush mode, set to 2.
#'   \item \code{Z_TREES}: Tree block compression mode, set to 6.
#' }
#'
#' @return A named list of zlib constants.
#' @examples
#' constants <- zlib_constants()
#' @keywords internal
zlib_constants <- function() {
    .Call(`_zlib_zlib_constants`)
}

#' Create a new decompressor object
#'
#' Initialize a new decompressor object for zlib-based decompression.
#' @param wbits The window size bits parameter. Default is 0.
#' @return A SEXP pointer to the new decompressor object.
#' @examples
#' decompressor <- create_decompressor()
#' @export
create_decompressor <- function(wbits = 0L) {
    .Call(`_zlib_create_decompressor`, wbits)
}

#' Decompress a chunk of data
#'
#' Perform chunk-wise decompression on a given raw vector using a decompressor object.
#' @param decompressorPtr An external pointer to an initialized decompressor object.
#' @param input_chunk A raw vector containing the compressed data chunk.
#' @return A raw vector containing the decompressed data.
#' @examples
#' rawToChar(decompress_chunk(create_decompressor(), memCompress(charToRaw("Hello, World"))))
#' @export
decompress_chunk <- function(decompressorPtr, input_chunk) {
    .Call(`_zlib_decompress_chunk`, decompressorPtr, input_chunk)
}

#' Flush the internal buffer of the decompressor object.
#'
#' This function processes all pending input and returns the remaining uncompressed output.
#' After calling this function, the decompress_chunk() method cannot be called again on the same object.
#' @param decompressorPtr A SEXP pointer to an existing decompressor object.
#' @param length An optional parameter that sets the initial size of the output buffer. Default is 256.
#' @return A raw vector containing the remaining uncompressed output.
#' @examples
#' decompressor <- create_decompressor()
#' # ... (some decompression actions)
#' flushed_data <- flush_decompressor_buffer(decompressor)
#' @export
flush_decompressor_buffer <- function(decompressorPtr, length = 256L) {
    .Call(`_zlib_flush_decompressor_buffer`, decompressorPtr, length)
}

#' Validate if a File is a Valid Gzip File
#'
#' This function takes a file path as input and checks if it's a valid gzip-compressed file.
#' It reads the file in chunks and tries to decompress it using the zlib library.
#' If any step fails, the function returns \code{FALSE}. Otherwise, it returns \code{TRUE}.
#'
#' @param file_path A string representing the path of the file to validate.
#' @return A boolean value indicating whether the file is a valid gzip file.
#'         \code{TRUE} if the file is valid, \code{FALSE} otherwise.
#' @examples
#' validate_gzip_file("path/to/your/file.gz")
#' @export
validate_gzip_file <- function(file_path) {
    .Call(`_zlib_validate_gzip_file`, file_path)
}

