% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_list_zctas.R
\name{zi_list_zctas}
\alias{zi_list_zctas}
\title{List ZCTA GEOIDs for States}
\usage{
zi_list_zctas(year, state, method)
}
\arguments{
\item{year}{A four-digit numeric scalar for year. \code{zippeR} currently
supports data between 2010 and 2021.}

\item{state}{A scalar or vector with state abbreviations (e.x. \code{"MO"})
or FIPS codes (e.x. \code{29}).}

\item{method}{A character scalar - either \code{"intersect"} or \code{"centroid"}.
See Details below.}
}
\value{
A vector of GEOIDs representing ZCTAs in and around the state selected.
}
\description{
This function returns a vector of GEOIDs that represent ZCTAs
    in and around states, depending on the method selected. The two methods
    included described in Details below.
}
\details{
Since ZCTAs cross state lines, two methods are used to create these
    vectors. The \code{"intersect"} method will return ZCTAs that border
    the state selected. In most cases, this will result in more ZCTAs
    being returned than are actually within the states(s) named in the
    \code{state} argument. Conversely, the \code{"centroid"} method will
    return only ZCTAs whose centroids (geographical centers) lie within the
    states named. In most cases, this will return fewer ZCTAs than
    actually lie within the state selected. Users will need to review
    their data carefully and, when using other \code{zipperR} functions,
    will likely need to use the \code{include} and \code{exclude} arguments
    to finalize the geographies returned.
}
\examples{
# Missouri ZCTAs, intersect method
## return list
mo_zctas <- zi_list_zctas(year = 2021, state = "MO", method = "intersect")

## preview ZCTAs
mo_zctas[1:10]

# Missouri ZCTAs, centroid method
## return list
mo_zctas <- zi_list_zctas(year = 2021, state = "MO", method = "centroid")

## preview ZCTAs
mo_zctas[1:10]

}
