% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmviterbi.R
\name{hmmviterbi}
\alias{hmmviterbi}
\title{Viterbi algorithm to decode the latent states for hidden Markov models}
\usage{
hmmviterbi(y, ntimes = NULL, M, prior_init, tpm_init, emit_init, zero_init,
  plot = FALSE, xlim = NULL, ylim = NULL, ...)
}
\arguments{
\item{y}{the observed series to be decoded}

\item{ntimes}{vector specifying the lengths of individual, 
i.e. independent, time series. If not specified, the responses are assumed to 
form a single time series, i.e. ntimes=length(y)}

\item{M}{number of latent states}

\item{prior_init}{a vector of prior probability values}

\item{tpm_init}{transition probability matrix}

\item{emit_init}{a vector containing means for each poisson distribution}

\item{zero_init}{a vector containing structural zero proportions in each state}

\item{plot}{whether a plot should be returned}

\item{xlim}{vector specifying the minimum and maximum on the x-axis in the plot. 
Default to NULL.}

\item{ylim}{vector specifying the minimum and maximum on the y-axis in the plot. 
Default to NULL.}

\item{...}{further arguments to be passed to the plot() function}
}
\value{
the decoded series of latent states
}
\description{
Viterbi algorithm to decode the latent states for hidden Markov models
}
\examples{
prior_init <- c(0.5,0.2,0.3)
emit_init <- c(10,40,70)
zero_init <- c(0.5,0,0)
omega <- matrix(c(0.5,0.3,0.2,0.4,0.3,0.3,0.2,0.4,0.4),3,3,byrow=TRUE)
result <- hmmsim(n=1000,M=3,prior=prior_init, tpm_parm=omega,
         emit_parm=emit_init,zeroprop=zero_init)
y <- result$series
state <- result$state
fit <- hmmfit(y=y,M=3,prior_init=prior_init,tpm_init=omega,
     emit_init=emit_init,zero_init=zero_init,
     method="Nelder-Mead",hessian=FALSE,control=list(maxit=500,trace=1))

decode <- hmmviterbi(y,NULL,3,fit$prior,fit$tpm,fit$emit_parm,fit$zeroprop,
                      plot=TRUE,xlab="Time",ylab="Count")      
#check the missclassification rate
sum(decode!=state)/length(state)      

\dontrun{
decode <- hmmviterbi(y,NULL,3,fit$prior,fit$tpm,fit$emit_parm,fit$zeroprop,
                      plot=TRUE,xlim=c(0,100),ylim=c(0,100),
                      xlab="Time",ylab="Count")  
}
}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}
