% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwt-spectrogram.R
\name{cwt_spectrogram}
\alias{cwt_spectrogram}
\title{Computes a spectrogram using CWT}
\usage{
cwt_spectrogram(x, period_range = c(hours(1), hours(32)),
  sampling_rate = 1/mins(1), resolution = 1/64,
  summary_time_window = mins(30))
}
\arguments{
\item{x}{numeric vector}

\item{period_range}{vector of size 2 defining minimal and maximal range of period to study (in seconds)}

\item{sampling_rate}{the -- implicitly regular -- sampling rate of x (in hertz)}

\item{resolution}{the period resolution of the CWT (i.e. the number of suboctaves)}

\item{summary_time_window}{the sampling period after post-processing.
Values of power are avegraged over this time window, for each period.}
}
\description{
A port of Continuous Wavelet transform to \code{rethomics}.
This function is intended to be used as an argument in the \link{spectrogram} wrapper.
}
\seealso{
\itemize{
\item \link{spectrogram} -- to apply this fucntion to all indivvidual, with some preprocessing.
\item \link[WaveletComp:analyze.wavelet]{WaveletComp::analyze.wavelet} -- the orginal function for \code{cwt_spectrogram}
}
}
