% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periodogram.R
\name{periodogram}
\alias{periodogram}
\title{Computes periodograms}
\usage{
periodogram(var, data, period_range = c(hours(16), hours(32)),
  resample_rate = 1/mins(15), alpha = 0.01, FUN = chi_sq_periodogram, ...)
}
\arguments{
\item{var}{variable to analyse}

\item{data}{\link{behavr} table}

\item{period_range}{vector of size 2 defining minimal and maximal range of period to study (in seconds)}

\item{resample_rate}{frequency to resample (up or down) the data at (in hertz)}

\item{alpha}{significance level}

\item{FUN}{function used to compute periodogram (see \link{periodogram_methods})}

\item{...}{additional arguments to be passed to FUN}
}
\value{
A \link[behavr:behavr]{behavr::behavr} table.
In addition to the metadata, it contains data that encodes a periodogram (i.e. power vs period).
The data contains the columns:
\itemize{
\item \code{power} -- the power the or equivalent (according to \code{FUN})
\item \code{period} -- the period at which \code{power} is computed (in seconds)
\item \code{p_value} -- the p value associated to the power estimation
\item \code{signif threshold} -- the threshold above which power is considered significant
}
}
\description{
This function builds periodograms, with one of several methods, for each individual of a \link{behavr} table
}
\examples{
data(dams_sample)
# only a half of the individuals for the sake of the example
dt <- dams_sample[xmv(region_id) \%in\% (1:16 * 2)]
pdt <- periodogram(activity, dt, FUN = ls_periodogram, oversampling = 4)
pdt <- periodogram(activity, dt, FUN = chi_sq_periodogram)
\donttest{
require(ggetho)
ggperio(pdt, aes(colour=period_group)) + stat_pop_etho()
}

}
\references{
\itemize{
\item \href{https://rethomics.github.io/zeitgebr.html}{zeitgebr tutorial} -- the relevant rehtomics tutorial
}
}
\seealso{
\itemize{
\item \link{periodogram_methods} -- the list of built-in methods
\item \link{find_peaks} -- to find peaks in the periodogram
\item \link[ggetho:ggperio]{ggetho::ggperio} -- to plot periodograms
}
}
