% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_association.R
\name{local_association}
\alias{local_association}
\alias{duchers_z}
\alias{pmi}
\alias{npmi}
\title{Local Association Measures}
\usage{
local_association(x, measure)

duchers_z(x)

pmi(x, normalize = FALSE)

npmi(x)
}
\arguments{
\item{x}{list of probabilities as outputted by \code{\link[zebu]{estimate_prob}}.}

\item{measure}{name of measure to be used:
\itemize{
\item'z': Ducher's 'z'.
\item'pmi': Pointwise mutual information.
\item'npmi': Normalized pointwise mutual information.
}}

\item{normalize}{Normalizes pointwise mutual information when calling \code{pmi}}
}
\value{
List containing the following values:
\itemize{
\item local: local association array (may contain NA, NaN and Inf values).
\item global: global association numeric value.
}
}
\description{
Subroutines called by \code{\link[zebu]{lassie}} to compute
local and global association measures from a list of probabilities.
}
\details{
\itemize{
\item \code{local_association(x, measure = 'z')} is equivalent to
\code{duchers_z(x)}.
\item \code{local_association(x, measure = 'pmi')} is equivalent to
\code{pmi(x)}.
\item \code{local_association(x, measure = 'npmi')} is equivalent to
\code{npmi(x)} and \code{pmi(x, normalize = TRUE)}.
}
}
\examples{
# This is what happens behind the curtains in the 'lassie' function
# Here we compute the association between the 'Girth' and 'Height' variables
# of the 'trees' dataset

# 'select' and 'continuous' take column numbers or names
select <- c('Girth', 'Height') # select subset of trees
continuous <-c(1, 2) # both 'Girth' and 'Height' are continuous

# equal-width discretization with 3 bins
breaks <- 3

# Preprocess data: subset, discretize and remove missing data
pre <- preprocess(trees, select, continuous, breaks)

# Estimates marginal and multivariate probabilities from preprocessed data.frame
prob <- estimate_prob(pre$pp)

# Computes local and global association using Ducher's Z
lam <- local_association(prob, measure = 'z')
}
\seealso{
\code{\link[zebu]{lassie}}
}
