% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae.R
\name{aeMarginal}
\alias{aeMarginal}
\title{Asymptotic Expansion - Marginals}
\usage{
aeMarginal(ae, var)
}
\arguments{
\item{ae}{an object of class \code{\link{yuima.ae-class}}.}

\item{var}{variables of the marginal distribution to compute.}
}
\value{
An object of \code{\link{yuima.ae-class}}
}
\description{
Asymptotic Expansion - Marginals
}
\examples{
\dontrun{
# multidimensional model
gbm <- setModel(drift = c('mu*x1','mu*x2'), 
                diffusion = matrix(c('sigma1*x1',0,0,'sigma2*x2'), nrow = 2), 
                solve.variable = c('x1','x2'))

# settings
xinit <- c(100, 100)
par <- list(mu = 0.01, sigma1 = 0.2, sigma2 = 0.1)
sampling <- setSampling(Initial = 0, Terminal = 1, n = 1000)

# asymptotic expansion
approx <- ae(model = gbm, sampling = sampling, order = 3, true.parameter = par, xinit = xinit)

# extract marginals
margin1 <- aeMarginal(ae = approx, var = "x1")
margin2 <- aeMarginal(ae = approx, var = "x2")

# compare with exact solution for marginal 1
x1 <- seq(50, 200, by = 0.1)
exact <- dlnorm(x = x1, meanlog = log(xinit[1])+(par$mu-0.5*par$sigma1^2), sdlog = par$sigma1)
plot(x1, exact, type = 'p', ylab = "Density")
lines(x1, aeDensity(x1 = x1, ae = margin1, order = 3), col = 2)

# compare with exact solution for marginal 2
x2 <- seq(50, 200, by = 0.1)
exact <- dlnorm(x = x2, meanlog = log(xinit[2])+(par$mu-0.5*par$sigma2^2), sdlog = par$sigma2)
plot(x2, exact, type = 'p', ylab = "Density")
lines(x2, aeDensity(x2 = x2, ae = margin2, order = 3), col = 2)

}
}
