% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploitation.R
\name{ypr_exploitation}
\alias{ypr_exploitation}
\title{Exploitation Probability}
\usage{
ypr_exploitation(population, pi = population$pi)
}
\arguments{
\item{population}{An object of class \code{\link{ypr_population}}.}

\item{pi}{A vector of capture probabilities to calculate the exploitation probabilities for.}
}
\value{
A vector of exploitation probabilities.
}
\description{
Converts capture probabilities into exploitation probabilities based on the
release and handling mortality probabilities where
the probability of exploitation includes handling mortalities.
The calculation assumes that a released fish cannot be recaught in the same year.
}
\details{
In the case of no release (or 100% handling mortalities) the exploitation probability
is identical to the capture probability.
Otherwise it is less.
}
\examples{
ypr_exploitation(ypr_population(pi = 0.4))
ypr_exploitation(ypr_population(pi = 0.4, rho = 0.6, Hm = 0.2))
}
\seealso{
\code{\link{ypr_population}}
}
