% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse.R
\name{collapsePane}
\alias{collapsePane}
\alias{hideCollapsePane}
\alias{showCollapsePane}
\alias{toggleCollapsePane}
\title{Collapsible panes}
\usage{
collapsePane(id, ..., show = FALSE, animate = TRUE)

hideCollapsePane(id, session = getDefaultReactiveDomain())

showCollapsePane(id, session = getDefaultReactiveDomain())

toggleCollapsePane(id, session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{A character string specifying the id of the collapse pane.}

\item{...}{Tag elements inside the collapsible pane or additional named
arguments passed as HTML attributes to parent element.}

\item{show}{One of \code{TRUE} or \code{FALSE} specifying if the collapsible pane
is shown when the page renders, defaults to \code{FALSE}.}

\item{animate}{One of \code{TRUE} or \code{FALSE} specifying if showing and closing the
collapsible pane is animated, defaults to \code{TRUE}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
The \code{collapsePane()} creates a collapsible container. The state of the
container, expanded or collapsed, is toggled using \code{showCollapsePane()},
\code{hideCollapsePane()}, and \code{toggleCollapsePane()}.
}
\details{
Padding may not be applied to the collapsible pane div element. To pad a
collapsible pane first wrap the pane in another element and add padding to
this new element.
}
\section{App with collapse}{
\if{html}{\out{<div class="R">}}\preformatted{ui <- container(
  buttonInput(
    id = "demo",
    label = "Toggle collapse"
  ),
  collapsePane(
    id = "collapse",
    p(
      "Pellentesque condimentum, magna ut suscipit hendrerit, ",
      "ipsum augue ornare nulla, non luctus diam neque sit amet urna."
    ),
    p(
      "Praesent fermentum tempor tellus.  Vestibulum convallis, ",
      "lorem a tempus semper, dui dui euismod elit, vitae placerat ",
      "urna tortor vitae lacus."
    )
  )
)

server <- function(input, output) \{
  observeEvent(input$demo, \{
    toggleCollapsePane("collapse")
  \})
\}

shinyApp(ui, server)
}\if{html}{\out{</div>}}
}

\examples{

### Examples

# As these are server-side utilities, please run the example applications
# above.

}
\seealso{
Other components: 
\code{\link{alert}()},
\code{\link{badge}()},
\code{\link{blockquote}()},
\code{\link{card}()},
\code{\link{d1}()},
\code{\link{dropdown}()},
\code{\link{img}()},
\code{\link{jumbotron}()},
\code{\link{modal}()},
\code{\link{navContent}()},
\code{\link{popover}()},
\code{\link{pre}()},
\code{\link{toast}()}
}
\concept{components}
