% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initiation_points_methods.R
\name{bam_to_reads}
\alias{bam_to_reads}
\title{Convert BAM files into BED files containing the reads overlaping the specified annotations.}
\usage{
bam_to_reads(bamfile, annotations, paired_end = TRUE, as_fragments = TRUE,
  outfile = NULL, flanking_region = 0)
}
\arguments{
\item{bamfile}{a character vector indicating the BAM file name.
Note: The bamfile must be sorted by coordinates.}

\item{annotations}{an object of type \code{\link{annotationsSet}}
containing information on one genes.}

\item{paired_end}{logical indicating whether the \code{bamfile}
contains paired-end data.}

\item{as_fragments}{logical indicating if paired-end data must be paired
and merged to form fragments.}

\item{outfile}{a character vector indicating the output file name.
If not provided, the result will be internalized in R.}

\item{flanking_region}{Number of bases before and after the gene ORF should be included.}
}
\value{
An object of type \code{\link[data.table]{data.table}} with 9 columns.
 \tabular{ll}{
   chromosome        \tab Read chromosome.\cr
   start             \tab Read starting position.\cr
   end               \tab Read ending position.\cr
   name              \tab Query template name .\cr
   score             \tab Mapping quality.\cr
   ChromosomeNext    \tab Gene strand.\cr
   startNext         \tab Position of the mate/next read.\cr
   tlen              \tab observed read length.\cr
   flag              \tab bitwise flag.
 }
}
\description{
Convert BAM files into BED files containing the reads overlaping the specified annotations.
}
\examples{
bamfile <- system.file("extdata", "wt_rep1.bam", package = "yCrypticRNAs")
data(annotations)
bam_to_reads(bamfile, annotations)
}

