% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariates.R
\name{eta_grid}
\alias{eta_grid}
\alias{cov_grid}
\alias{eta_vs_cov_grid}
\title{Grid plots}
\usage{
eta_grid(
  xpdb,
  mapping = NULL,
  etavar = NULL,
  drop_fixed = TRUE,
  title = "Eta correlations | @run",
  subtitle = "Based on @nind individuals, Eta shrink: @etashk",
  caption = "@dir",
  tag = NULL,
  pairs_opts,
  .problem,
  quiet,
  ...
)

cov_grid(
  xpdb,
  mapping = NULL,
  cols = NULL,
  covtypes = c("cont", "cat"),
  show_n = TRUE,
  drop_fixed = TRUE,
  title = "Covariate relationships | @run",
  subtitle = "Based on @nind individuals",
  caption = "@dir",
  tag = NULL,
  pairs_opts,
  .problem,
  quiet,
  ...
)

eta_vs_cov_grid(
  xpdb,
  mapping = NULL,
  etavar = NULL,
  cols = NULL,
  covtypes = c("cont", "cat"),
  show_n = TRUE,
  drop_fixed = TRUE,
  title = "Eta covariate correlations | @run",
  subtitle = "Based on @nind individuals, Eta shrink: @etashk",
  caption = "@dir",
  tag = NULL,
  etacov = TRUE,
  pairs_opts,
  .problem,
  quiet,
  ...
)
}
\arguments{
\item{xpdb}{<\verb{xp_xtras> or  <}xpose_data`> object}

\item{mapping}{\code{ggplot2} style mapping}

\item{etavar}{\code{tidyselect} for \code{eta} variables}

\item{drop_fixed}{As in \code{xpose}}

\item{title}{Plot title}

\item{subtitle}{Plot subtitle}

\item{caption}{Plot caption}

\item{tag}{Plot tag}

\item{pairs_opts}{List of arguments to pass to \verb{_opts}. See <\code{\link{xplot_pairs}}>}

\item{.problem}{Problem number}

\item{quiet}{Silence extra debugging output}

\item{...}{Passed to \code{xplot_pairs}}

\item{cols}{\code{tidyselect} for covariates variables}

\item{covtypes}{Subset to specific covariate type?}

\item{show_n}{Count the number of \code{ID}s in each category}

\item{etacov}{For\code{eta_vs_cov_grid}, \code{eta} are sorted after covariates to
give an \code{x} orientation to covariate relationships.}
}
\value{
\code{xp_tras_plot} object
}
\description{
This is essentially a wrapper around \code{\link[GGally:ggpairs]{ggpairs}},
except it uses \code{xpose} motifs and styling. Note that this function
produces a lot of repetitive output if \code{quiet=FALSE}; this may not
be an issue, but it could look like an error has occurred if many covariates
and individual parameter estimates are included.
}
\examples{
\donttest{

eta_grid(xpdb_x)
cov_grid(xpdb_x)
eta_vs_cov_grid(xpdb_x)

# Labels and units are also supported
xpdb_x \%>\%
  xpose::set_var_labels(AGE="Age", MED1 = "Digoxin") \%>\%
  xpose::set_var_units(AGE="yrs") \%>\%
  set_var_levels(SEX=lvl_sex(), MED1 = lvl_bin()) \%>\%
  eta_vs_cov_grid()

}
}
