% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_catalogue.R
\name{style_catalogue_add_openxlsx_style}
\alias{style_catalogue_add_openxlsx_style}
\title{Manually add an openxlsx s4 style the style catalogue}
\usage{
style_catalogue_add_openxlsx_style(tab, style_string, openxlsx_style,
  row_height = NULL)
}
\arguments{
\item{tab}{a table object}

\item{style_string}{the name (key) in the tab$style_catalogue}

\item{openxlsx_style}{an openxlsx s4 style}

\item{row_height}{the height of the row.  optional.}
}
\description{
Manually add an openxlsx s4 style the style catalogue
}
\examples{
tab <- xltabr::initialise()
s4style <- openxlsx::createStyle(fontName = "Courier",
                                 fontColour = "#80a9ed",
                                 fontSize = 20,
                                 numFmt =  "£    #,###")
tab <- style_catalogue_add_openxlsx_style(tab, "custom", s4style, row_height = 40)
}
