% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTradeAggregations.R
\name{getTradeAggregations}
\alias{getTradeAggregations}
\title{Returns trade aggregations.}
\usage{
getTradeAggregations(start_time, end_time, resolution, limit = 10,
  order = "asc", base_asset_type, base_asset_code = "",
  base_asset_issuer = "", counter_asset_type, counter_asset_code = "",
  counter_asset_issuer = "", data.table = FALSE, domain = "public")
}
\arguments{
\item{start_time}{numeric - milliseconds since epoch}

\item{end_time}{numeric - milliseconds since epoch}

\item{resolution}{numeric - segment duration as millis since epoch. Supported values are 5 minutes (300000), 15 minutes (900000), 1 hour (3600000), 1 day (86400000) and 1 week (604800000).}

\item{limit}{numeric - optional, the number of records to return. Default is 10.}

\item{order}{character - optional, "asc" or "desc"}

\item{base_asset_type}{string - type of base asset}

\item{base_asset_code}{string - code of base asset, not required if type is native}

\item{base_asset_issuer}{string - issuer of base asset, not required if type is native}

\item{counter_asset_type}{string - type of counter asset}

\item{counter_asset_code}{string - code of counter asset, not required if type is native}

\item{counter_asset_issuer}{string - issuer of counter asset, not required if type is native}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}

\item{domain}{- character - signalling to query the testnet or public network. Can be either "testnet" or "public".}
}
\value{
data.table or list
}
\description{
Gather historical trading data directly from the API.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/trade_aggregations.html
}
\examples{
start_time="1512689100000"
end_time="1534924458000"
resolution="300000"
base_asset_type="native"
counter_asset_type="credit_alphanum4"
counter_asset_code="BTC"
counter_asset_issuer = "GATEMHCCKCY67ZUCKTROYN24ZYT5GK4EQZ65JJLDHKHRUZI3EUEKMTCH"

getTradeAggregations(start_time, end_time, resolution,
base_asset_type = base_asset_type, counter_asset_type = counter_asset_type,
counter_asset_code = counter_asset_code, counter_asset_issuer = counter_asset_issuer)
}
