% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaDecode.R
\name{xegaGaGeneMapIdentity}
\alias{xegaGaGeneMapIdentity}
\title{Map the bit strings of a binary gene to an identical bit vector.}
\usage{
xegaGaGeneMapIdentity(gene, penv)
}
\arguments{
\item{gene}{A binary gene (the genotype).}

\item{penv}{A problem environment.}
}
\value{
The decoded gene (the phenotype).
}
\description{
\code{xegaGaGenemapIdentity} maps the bit strings 
             of a binary vector
             to an identical binary vector.
             Faster for all problems with single-bit coding.
             Examples: Knapsack, Number Partitioning into 2 partitions.
}
\examples{
gene<-xegaGaInitGene(lFxegaGaGene)
xegaGaGeneMapIdentity(gene$gene1, lFxegaGaGene$penv)

}
\seealso{
Other Decoder: 
\code{\link{xegaGaDecodeGene}()},
\code{\link{xegaGaGeneMapGray}()},
\code{\link{xegaGaGeneMapPerm}()},
\code{\link{xegaGaGeneMap}()}
}
\concept{Decoder}
