% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hf.R
\name{hf}
\alias{hf}
\title{Parameters calculation for adjustment of W-test}
\usage{
hf(data, w.order, B = 400, n.sample = nrow(data),
  n.marker = "default.nmarker")
}
\arguments{
\item{data}{a data frame or matrix contains genotypes in the columns. Genotypes should be coded as (0, 1, 2) or (0, 1).}

\item{w.order}{a numeric number taking values 1 or 2. If \code{w.order} = 1, main effect is calculated. If \code{w.order} = 2, pairwise interaction effect is calculated.}

\item{B}{a numeric number specify the number of replicates. Default is 400.}

\item{n.sample}{a numeric number specify the number of samples to be involved for estimating parameters. Default is the total number of samples in the data.}

\item{n.marker}{a numeric value, the number of biomarkers to use in bootstrapping. Default is the minumn value of total number of markers and 1,000 markers for order =1, and 50 markers for order =2.}
}
\value{
a set of parameters indexed by \emph{k}, obtained automatically. For main effect, \emph{k} is the number of levels of a predictor variable. For pairwise interactions, \emph{k} is the number of categorical combinations of a pair.
}
\description{
Function to estimate parameters (\emph{h} and \emph{f}) for \code{W-test}
}
\examples{
data(mydata)

# Please note that parameter B is recommended to be greater than 400.
# For high order interaction analysis (w.order > 2), it is recommended to use default n.sample.
hf1<-hf(data = mydata, w.order = 1, B = 100)
hf2<-hf(data = mydata, w.order = 2, B = 80)
}
\references{
Maggie Haitian Wang, Rui Sun, Junfeng Guo, Haoyi Weng, Jack Lee, Inchi Hu, Pak Sham and Benny C.Y. Zee (2016). A fast and powerful W-test for pairwise epistasis testing. Nucleic Acids Research.doi:10.1093/nar/gkw347.
}
\seealso{
\code{\link{wtest}}, \code{\link{w.diagnosis}}, \code{\link{w.qqplot}}
}
\author{
Rui Sun, Maggie Haitian Wang
}
