% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AucRoc.R
\name{AucROC}
\alias{AucROC}
\title{AUC from ROC-curves}
\usage{
AucROC(dat, useCol = c("spec", "sens"), silent = FALSE, callFrom = NULL)
}
\arguments{
\item{dat}{(matrix or data.frame) main inut containig sensitivity and specificity data (from \code{summarizeForROC})}

\item{useCol}{(character or integer) column names to be used: 1st for specificity and 2nd for sensitivity count columns}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
matrix including imputed values or list of final and matrix with number of imputed by group (plus optional plot)
}
\description{
This function calculates the AUC (area under the curve) from ROC data in matrix of specificity and sensitivity values,
as provided in the output from  \code{\link{summarizeForROC}}.
Note that numerous other packages also provide support for working with ROC-curves : Eg \href{https://CRAN.R-project.org/package=dlstats}{rocPkgShort}, 
 \href{https://CRAN.R-project.org/package=ROCR}{ROCR}, \href{https://CRAN.R-project.org/package=pROC}{pROC} or \href{https://CRAN.R-project.org/package=ROCit}{ROCit}
}
\examples{
set.seed(2019); test1 <- list(annot=cbind(spec=c(rep("b",35),letters[sample.int(n=3,
  size=150,replace=TRUE)])), BH=matrix(c(runif(35,0,0.01),runif(150)),ncol=1))
roc1 <- summarizeForROC(test1,spec=c("a","b","c"))
AucROC(roc1)
}
\seealso{
preparing ROC data \code{\link{summarizeForROC}}, (re)plot the ROC figure \code{\link{plotROC}}
}
