% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readProteomeDiscovererFile.R
\name{.extrSpecPref}
\alias{.extrSpecPref}
\title{Extract additional information to construct colum SpecType}
\usage{
.extrSpecPref(
  specPref,
  annot,
  useColumn = c("Species", "EntryName", "GeneName", "Accession"),
  suplInp = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{specPref}{(list) may contain $mainSpecies, $conta ...}

\item{annot}{(matrix) main protein annotation}

\item{useColumn}{(factor) columns from annot to use/mine}

\item{suplInp}{(matrix) additional custom annotation}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) display additional messages for debugging (starting with 'mainSpecies','conta' and others - later may overwrite prev settings)}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a matrix with additional column 'SpecType'
}
\description{
This (low-level) function creates the column annot[,'SpecType'] which may help distinguishing different lines/proteins.
This information may, for example, be used to normalize only to all proteins of a common backgroud matrix (species).
If $mainSpecies or $conta: match to annot[,"Species"], annot[,"EntryName"], annot[,"GeneName"], if length==1 grep in  annot[,"Species"]
}
\examples{
.commonSpecies()
}
\seealso{
used in \code{readProtDiscovererFile},  \code{\link{readMaxQuantFile}}, \code{\link{readProlineFile}}, \code{\link{readFragpipeFile}}
}
