% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{wb_indicator}
\alias{wb_indicator}
\title{World Bank indicator data}
\source{
\url{https://api.worldbank.org/v2/indicator}
}
\usage{
wb_indicator(indicator = NULL, lang = "en")
}
\arguments{
\item{indicator}{(\code{character(1)}) indicator to query. Default \code{NULL}.
If \code{NULL}, all indicators are returned.}

\item{lang}{(\code{character(1)}) language to query. Default \code{"en"}.}
}
\value{
A \code{data.frame()} with the available indicators. The columns are:
\item{id}{The indicator ID.}
\item{name}{The indicator name.}
\item{unit}{The indicator unit.}
\item{source_id}{The source ID.}
\item{source_value}{The source value.}
\item{source_note}{The source note.}
\item{source_organization}{The source organization.}
\item{topic_id}{The topic ID.}
\item{topic_value}{The topic value.}
}
\description{
List all indicators supported by the World Bank API.
}
\examples{
wb_indicator("NY.GDP.MKTP.CD")
}
\seealso{
Other indicators data: 
\code{\link{wb_country}()},
\code{\link{wb_income_level}()},
\code{\link{wb_language}()},
\code{\link{wb_lending_type}()},
\code{\link{wb_region}()},
\code{\link{wb_source}()},
\code{\link{wb_topic}()}
}
\concept{indicators data}
