% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readers.R
\name{read_raster_in_workspace}
\alias{read_raster_in_workspace}
\title{Read a raster from a workspace}
\usage{
read_raster_in_workspace(x, name)
}
\arguments{
\item{x}{the workspace object}

\item{name}{name of the raster dataset stored in the workspace}
}
\value{
The \code{splatRaster} object that was stored in TIFF format.
}
\description{
Read a raster dataset stored as a TIFF file in a workspace.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)
# Create and store example raster (requires terra package)
if (requireNamespace("terra", quietly = TRUE)) {
  r <- terra::rast(ncols=10, nrows=10, vals=1:100)
  z <- store_raster(x = z, dataset = r, name = "example_raster")
  retrieved_raster <- read_raster_in_workspace(z, name = "example_raster")
  retrieved_raster
}
}
\seealso{
\link{workspace} for package documentation

Other functions to read in a workspace: 
\code{\link{list_object_in_workspace}()},
\code{\link{read_dataset_in_workspace}()},
\code{\link{read_json_str_in_workspace}()},
\code{\link{read_rds_in_workspace}()},
\code{\link{read_timestamp}()},
\code{\link{read_yaml_in_workspace}()}
}
\concept{functions to read in a workspace}
