% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm.R
\name{delete_dataset}
\alias{delete_dataset}
\title{Delete a dataset from a workspace}
\usage{
delete_dataset(x, data_name)
}
\arguments{
\item{x}{The workspace object.}

\item{data_name}{The name of the dataset to delete from the workspace.}
}
\value{
Returns the \link{workspace} object passed to \code{x} parameter. Called primarily for side effects.
}
\description{
Delete a dataset stored in a workspace.
This function removes the dataset file and updates the workspace's object descriptions.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)
z <- store_dataset(x = z, dataset = iris, name = "iris_dataset")
z <- store_dataset(x = z, dataset = mtcars, name = "mtcars")
z <- delete_dataset(x = z, data_name = "iris_dataset")
z
}
\seealso{
\link{workspace} for package documentation

Other functions to write in a workspace: 
\code{\link{store_dataset}()},
\code{\link{store_json}()},
\code{\link{store_raster}()},
\code{\link{store_rds}()},
\code{\link{store_yaml}()}
}
\concept{functions to write in a workspace}
