% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local-versions.R
\name{wood_local_versions}
\alias{wood_local_versions}
\title{Get locally available package versions}
\usage{
wood_local_versions(package, paths = .libPaths()[1])
}
\arguments{
\item{package}{\code{character(1)}\cr
Name of a package to query for.}

\item{paths}{\code{character()}\cr
Paths to local libraries, by default the first element of \code{.libPaths()}. If
equal to \code{"all"}, uses all elements of \code{.libPaths()}.}
}
\value{
A character vector of version codes.
}
\description{
This function searches for installed package versions inside
specified library paths.
}
\examples{
wood_local_versions("httr")

}
\seealso{
Functions for local libraries:
\code{\link{wood_local_dependencies}()},
\code{\link{wood_local_packages}()}

Functions that query package versions:
\code{\link{wood_bioc_version}()},
\code{\link{wood_core_version}()},
\code{\link{wood_cran_latest}()},
\code{\link{wood_cran_versions}()},
\code{\link{wood_github_latest}()},
\code{\link{wood_github_versions}()},
\code{\link{wood_runiverse_version}()},
\code{\link{wood_url_version}()},
\code{\link{wood_versions}()}
}
\concept{local}
\concept{versions}
