% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioc-version.R
\name{wood_bioc_version}
\alias{wood_bioc_version}
\title{Get available package version in Bioconductor}
\usage{
wood_bioc_version(package, release = "release")
}
\arguments{
\item{package}{\code{character(1)}\cr
Name of a package to query for.}

\item{release}{\code{character(1)}\cr
Bioconductor release to query for. Can be either a numeric code (like
\code{3.12}) or one of two keywords: \code{"release"} and \code{"devel"}.}
}
\value{
A single string with a version code.
}
\description{
This function queries Bioconductor for the code of the available
version of the selected package for given Bioconductor release.
}
\examples{
\donttest{
wood_bioc_version("Biostrings")

# What's coming next?
wood_bioc_version("Biostrings", release = "devel")
# Can query releases as old as 1.5:
wood_bioc_version("Biostrings", release = "1.5")
}

}
\seealso{
Functions for Bioconductor:
\code{\link{wood_bioc_dependencies}()},
\code{\link{wood_bioc_packages}()},
\code{\link{wood_bioc_releases}()}

Functions that query package versions:
\code{\link{wood_core_version}()},
\code{\link{wood_cran_latest}()},
\code{\link{wood_cran_versions}()},
\code{\link{wood_github_latest}()},
\code{\link{wood_github_versions}()},
\code{\link{wood_local_versions}()},
\code{\link{wood_runiverse_version}()},
\code{\link{wood_url_version}()},
\code{\link{wood_versions}()}
}
\concept{bioc}
\concept{versions}
