%%  WARNING: This file was automatically generated from the associated 
%%  wav_filt.mid file. Do NOT edit this Rd file to make a change. Instead, 
%%  edit the wav_filt.mid file in the project MID directory. Once the 
%%  wav_filt.mid file has been updated, this Rd file, and all other 
%%  documentation (such as corresponding LaTeX, SGML and HTML documentation) 
%%  should be regenerated using the mid.pl Perl script. 

%% R documentation for the wavShift function

\name{wavShift}
\alias{wavShift}
\title{Shifts wavelet transform coefficients for approximate zero phase alignment}
\concept{waveletzero phase shifting}
\usage{wavShift(x)}
\description{If Daubechies symmlet or coiflet filters are used in forming a DWT or MODWT (ala \code{wavDWT} or \code{wavMODWT}, respectively), then
the transform coefficients can be circularly rotated so that they are
approximately aligned (in time) with events of the original time series.
An appropriate shift of the coefficients (generated by approximate linear phase filter operations)
is approximately equivalent to using zero phase filters in the wavelet transform.}

\arguments{
\item{x}{an object of class \code{wavTransform} or \code{wavBoundary}.}

}

\value{
an object of the same class as the input with the transform coefficients adjusted
to approximate zero phase filtering operations.
}
\details{
%
Only relevant for transforms calculated using Daubechies coiflet and symmlet filters. A second
application of \code{wavShift} to the same input object
will result in the original input object, i.e. without any imposed shift in the transform
coefficients.
}
\references{
D. B. Percival and  A. T. Walden,
\emph{Wavelet Methods for Time Series Analysis}, Cambridge University Press, 2000.

I. Daubechies,
\emph{Orthonormal Bases of Compactly Supported Wavelets},
Communications on Pure and, Applied Mathematics, 41, 909--96.
}

\seealso{
\code{\link{wavZeroPhase}},
\code{\link{wavDWT}},
\code{\link{wavMODWT}}.
}

\examples{
## plot the zero phase shifted MODWT of a linear 
## chirp sequence 
linchirp <- make.signal("linchirp", n=1024)
plot(wavShift(wavMODWT(linchirp, wavelet="s8",
    n.levels=4, keep.series=TRUE)))
}
\keyword{univar}

