% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conDisplacement.R
\name{conDisplacement}
\alias{conDisplacement}
\title{Calculate net displacement from contacts}
\usage{
conDisplacement(traj, def = "all")
}
\arguments{
\item{traj}{an object of the class \code{move2} which should be output from the function \code{conPhase}.}

\item{def}{how to define the point-of-contact. The default is to define it as all fixes in a phase \code{type = 'all'}, alternatively contacts can be defined as a single point along the phase defined as one of: \code{'first','last','minDist','minTime'}, which corresponds to the first fix int he contact phase, the last fix in the contact phase, the fix with the minimum time difference and the fix with the closest contact distance.}
}
\value{
An move2 object with a new 'contact_displacement' column indicating the straight-line distance to the nearest (in time) contact phase (defined using parameter def). If there are no contacts associated with an individual the contact displacement is NA.
}
\description{
Calculate the net-displacement (distance) of fixes before and after a contact phase from the nearest contact pahse in time.
}
\details{
This function is used to compute the net displacement away from contacts by an animal before and after a contact phase. Net displacement represents an important variable related to the movement of the individual.
}
\examples{
\dontrun{
data(does)
doecons <- conProcess(does,tc=15*60,dc=50)
doephas <- conPhase(doecons,pc=60*60)
disp_f <- conDisplacement(doephas,def='first')
disp_l <- conDisplacement(doephas,def='last')
}

}
\references{
Long, JA, Webb, SL, Harju, SM, Gee, KL (2022) Analyzing Contacts and Behavior from High Frequency 
 Tracking Data Using the wildlifeDI R Package. \emph{Geographical Analysis}. \bold{54}, 648--663.
}
\seealso{
conProcess, conPhase, conTimelag
}
\keyword{contacts}
