% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Don.R
\name{Don}
\alias{Don}
\title{Doncaster's measure of dynamic interaction}
\usage{
Don(traj1, traj2, tc = 0, dc = 50, plot = TRUE)
}
\arguments{
\item{traj1}{an object of the class \code{ltraj} which contains the time-stamped
movement fixes of the first object. Note this object must be a \code{type II
ltraj} object. For more information on objects of this type see \code{
help(ltraj)}.}

\item{traj2}{same as \code{traj1}.}

\item{tc}{time threshold for determining simultaneous fixes -- see function: \code{GetSimultaneous}.}

\item{dc}{distance tolerance limit (in appropriate units) for defining when 
two fixes are spatially together.}

\item{plot}{logical, whether or not to plot the Doncaster plot. Default = TRUE.}
}
\value{
This function first returns a plot, for distance values ranging from 0 to the maximum
distance separating two fixes, of the observed proportion of simultaneous fixes below
each distance value. The expected values based on all fixes are also included.
Second, a list is returned that contains the contingency table of simultaneous fixes
(paired) and non-paired fixes below and above \code{dc}, along with the
associated \emph{p}-value from the Chi-squared test.
\itemize{
 \item conTable -- contingency table showing frequency of paired and non-paired fixes above and below \code{dc}.
 \item p.value -- \emph{p}-value from the Chi-squared test of \code{conTable}.
 }
}
\description{
The function \code{Don} measures the dynamic interaction between two moving objects following
the methods outlined by Doncaster (1990).
}
\details{
This function can be used to compute the Doncaster (1990) methods for measuring
dynamic interaction between two objects. The Doncaster method tests the proportion
of simultaneous fixes that are below \code{dc} against that which would be
expected based on the distribution of distances between all fixes.
}
\examples{
data(deer)
deer37 <- deer[1]
deer38 <- deer[2]
#tc = 7.5 minutes, dc = 50 meters
Don(deer37, deer38, tc = 7.5*60, dc = 50)
}
\references{
Doncaster, C.P. (1992) Non-parametric estimates of interaction from radio-tracking
data. \emph{Journal of Theoretical Biology}, \bold{143}: 431-443.
}
\seealso{
GetSimultaneous
}
\keyword{indices}
