% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-rest-resource.R
\name{get_rest_resource}
\alias{get_rest_resource}
\title{Get resources from one of Wikipedia's \href{https://www.mediawiki.org/wiki/API}{two REST APIs}}
\usage{
get_rest_resource(
  ...,
  language = "en",
  api = c("core", "wikimedia", "wikimedia_org", "xtools"),
  response_format = c("json", "html"),
  response_type = NULL,
  failure_mode = c("error", "quiet")
)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> The URL components and query
parameters of the desired resources. Names of the arguments are ignored.
The function follows the \href{https://vctrs.r-lib.org/reference/vector_recycling_rules}{tidyverse vector recycling rules}, so all
vectors must have the same length or be of length one. Unnamed arguments
will be appended to the URL path; named arguments will be added as query
parameters}

\item{language}{Character vector of two-letter language codes}

\item{api}{The desired REST api:
"\href{https://www.mediawiki.org/wiki/API:REST_API}{core}",
"\href{https://www.mediawiki.org/wiki/Wikimedia_REST_API}{wikimedia}",
"\href{https://wikimedia.org/api/rest_v1/}{wikimedia_org}", or
"\href{https://www.mediawiki.org/wiki/XTools/API}{xtools}"}

\item{response_format}{The expected Content-Type of the response. Currently "html" and
"json" are supported.}

\item{response_type}{The schema of the response. If supplied, the results will
be parsed using the schema.}

\item{failure_mode}{How to respond if a request fails
"error", the default: raise an error
"quiet", silently return NA}
}
\value{
A list of responses. If \code{response_format} == "json", then the responses
will be simple R lists. If \code{response_format} == "html", then the responses
will \code{xml_document} objects. If \code{response_type} is supplied, the response
will be coerced into a \link[tibble:tbl_df-class]{tibble::tbl_df} or vector using the relevant schema.
If the response is a 'scalar list' (i.e. a list of length == 1), then it is
silently unlisted, returning a simple list or vector.
}
\description{
This function is intended for developer use. It makes it easy to quickly
generate vectorised calls to the different APIs.
}
