% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{m_XtoolsInfo}
\alias{m_XtoolsInfo}
\title{Gets various information from a Wikimedia page}
\usage{
m_XtoolsInfo(
  article,
  infotype = c("articleinfo", "prose", "links"),
  project = "en.wikipedia.org",
  redirects = FALSE
)
}
\arguments{
\item{article}{The title of the article to search. Only one article is allowed.}

\item{infotype}{The type of information to request: articleinfo, prose, links.
You also can type 'all' to retrieve all.
Note that the API also offer theses options: top_editors, assessments,
bot_data and automated_edits.}

\item{project}{The Wikimedia project, defaults en.wikipedia.org.}

\item{redirects}{If redirects==TRUE, then the information is obtained
of the destiny of the page. In that case, then the "original" element of
the returned list contains the original page, and the "page" element the
destiny page. Also, if infotype=='links, the sum of the in-links of all
redirections is assigned to links_in_count.}
}
\value{
A list with the information about the article.
}
\description{
Obtains information in JSON format about an article in the Wikimedia project
or NULL on errors. Use the wmflabs API. The XTools Page API endpoints offer data
related to a single page. See https://www.mediawiki.org/wiki/XTools/API/Page.
The URL of the API starts with 'https://xtools.wmcloud.org/api/page/'
}
\examples{
\dontrun{
x <-  m_XtoolsInfo(article="Cervantes", infotype="articleinfo", project="es.wikipedia.org")
xx <- m_XtoolsInfo(article="Cervantes", infotype="articleinfo", project="es.wikipedia.org",
                   redirects=TRUE)

y <-  m_XtoolsInfo(article="Miguel de Cervantes", infotype="links", project="es.wikipedia.org")
yy <- m_XtoolsInfo(article="Cervantes", infotype="links", project="es.wikipedia.org",
                    redirects=TRUE)
z  <- m_XtoolsInfo(article="Miguel de Cervantes", infotype="all", project="es.wikipedia.org")
zz <- m_XtoolsInfo(article="Cervantes", infotype="all", project="es.wikipedia.org",
                       redirects=TRUE)
}
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
