% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{wkt_bounding}
\alias{wkt_bounding}
\title{Convert WKT Objects into Bounding Boxes}
\usage{
wkt_bounding(wkt, as_matrix = FALSE)
}
\arguments{
\item{wkt}{a character vector of WKT objects.}

\item{as_matrix}{whether to return the results as a matrix (TRUE) or data.frame (FALSE). Set
to FALSE by default.}
}
\value{
either a data.frame or matrix, depending on the value of \code{as_matrix}, containing
four columns - \code{min_x}, \code{min_y}, \code{max_x} and \code{max_y} - representing the
various points of the bounding box. In the event that a valid bounding box cannot be generated
(due to the invalidity or incompatibility of the WKT object), NAs will be returned.
}
\description{
\code{\link{wkt_bounding}} turns WKT objects
(specifically points, linestrings, polygons, and multi-points/linestrings/polygons)
into bounding boxes.
}
\examples{
wkt_bounding("POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))")

}
\seealso{
\code{\link{bounding_wkt}}, to turn R-size bounding boxes into WKT objects.
}

