% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_edge_contamination}
\alias{wbt_edge_contamination}
\title{Edge contamination}
\usage{
wbt_edge_contamination(
  dem,
  output,
  flow_type = "mfd",
  zfactor = "",
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Name of the input DEM raster file; must be depressionless.}

\item{output}{Name of the output raster file.}

\item{flow_type}{Flow algorithm type, one of 'd8', 'mfd', or 'dinf'.}

\item{zfactor}{Optional multiplier for when the vertical and horizontal units are not the same.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Identifies grid cells within an input DEM that may be impacted by edge contamination for hydrological applications.
}
\keyword{HydrologicalAnalysis}
