% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_isobasins}
\alias{wbt_isobasins}
\title{Isobasins}
\usage{
wbt_isobasins(
  dem,
  output,
  size,
  connections = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{size}{Target basin size, in grid cells.}

\item{connections}{Output upstream-downstream flow connections among basins?.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Divides a landscape into nearly equal sized drainage basins (i.e. watersheds).
}
\keyword{HydrologicalAnalysis}
