% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_d_inf_flow_accumulation}
\alias{wbt_d_inf_flow_accumulation}
\title{D inf flow accumulation}
\usage{
wbt_d_inf_flow_accumulation(
  input,
  output,
  out_type = "Specific Contributing Area",
  threshold = NULL,
  log = FALSE,
  clip = FALSE,
  pntr = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE
)
}
\arguments{
\item{input}{Input raster DEM or D-infinity pointer file.}

\item{output}{Output raster file.}

\item{out_type}{Output type; one of 'cells', 'sca' (default), and 'ca'.}

\item{threshold}{Optional convergence threshold parameter, in grid cells; default is infinity.}

\item{log}{Optional flag to request the output be log-transformed.}

\item{clip}{Optional flag to request clipping the display max by 1 percent.}

\item{pntr}{Is the input raster a D-infinity flow pointer rather than a DEM?.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates a D-infinity flow accumulation raster from an input DEM.
}
