% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_centroid.R
\name{get_centroid}
\alias{get_centroid}
\title{Get a centroid from WKT or geojson}
\usage{
get_centroid(x)
}
\arguments{
\item{x}{Input, a wkt character string or geojson class object}
}
\value{
A length 2 numeric vector, with longitude first, latitude second
}
\description{
Get a centroid from WKT or geojson
}
\examples{
# WKT
str <- "POINT (-116.4000000000000057 45.2000000000000028)"
get_centroid(str)
str <- 'MULTIPOINT ((100.000 3.101), (101.000 2.100), (3.140 2.180))'
get_centroid(str)
str <- "MULTIPOLYGON (((40 40, 20 45, 45 30, 40 40)),
 ((20 35, 45 20, 30 5, 10 10, 10 30, 20 35), (30 20, 20 25, 20 15, 30 20)))"
get_centroid(str)

# Geojson as geojson class
str <- "POINT (-116.4000000000000057 45.2000000000000028)"
get_centroid(wkt2geojson(str))
str <- 'MULTIPOINT ((100.000 3.101), (101.000 2.100), (3.140 2.180))'
get_centroid(wkt2geojson(str))
str <- "MULTIPOLYGON (((40 40, 20 45, 45 30, 40 40)),
 ((20 35, 45 20, 30 5, 10 10, 10 30, 20 35), (30 20, 20 25, 20 15, 30 20)))"
get_centroid(wkt2geojson(str))
}
