% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_locations.R
\name{split_locations}
\alias{split_locations}
\title{Splits string of manually entered locations into one row for each location}
\usage{
split_locations(
  .,
  column_name = "locations",
  dummy_words = c("cities", "states", "provinces", "districts", "municipalities",
    "regions", "villages", "city", "state", "province", "district", "municipality",
    "region", "township", "village", "near", "department"),
  joiner_regex = ",|\\\\(|\\\\)|;|\\\\+|( and )|( of )"
)
}
\arguments{
\item{.}{data frame of disaster data}

\item{column_name}{name of the column containing the locations}

\item{dummy_words}{a vector of words that we don't want in our final output.}

\item{joiner_regex}{a regex that tells us how to split the locations}
}
\value{
same data frame with the location_word column added
}
\description{
Changes the unit of analysis from a disaster, to a disaster-location. This is useful as preprocessing before geocoding each disaster-location pair.

Can be used in piped operations, making it tidy!
}
\examples{
locs <- c("city of new york", "kerala, chennai municipality, and san francisco",
"mumbai region, district of seattle, sichuan province")
d <- tibble::as_tibble(locs)
split_locations(d, column_name = "value")

}
