% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avg.R
\name{avg}
\alias{avg}
\title{Average Images}
\usage{
avg(
  stimuli,
  texture = TRUE,
  norm = c("none", "twopoint", "rigid"),
  normpoint = 0:1
)
}
\arguments{
\item{stimuli}{list of stimuli to average}

\item{texture}{logical; whether textured should be averaged}

\item{norm}{how to normalise; see Details}

\item{normpoint}{points for twopoint normalisation}
}
\value{
list of stimuli with the average image and template
}
\description{
Create an average from a list of delineated stimuli.
}
\details{
\subsection{Normalisation options}{
\itemize{
\item none: averages will have all coordinates as the mathematical average of the coordinates in the component templates
\item twopoint: all images are first aligned to the 2 alignment points designated in \code{normpoint}. Their position is set to their position in the first image in stimuli
\item rigid: procrustes aligns all images to the position of the first image in stimuli
}
}

\subsection{Texture}{

This applies a representative texture to the average, resulting in composite images with more realistic texture instead of the very smooth, bland texture most other averaging programs create. See the papers below for methodological details.

B. Tiddeman, M. Stirrat and D. Perrett (2005). Towards realism in facial prototyping: results of a wavelet MRF method. Theory and Practice of Computer Graphics.

B. Tiddeman, D.M. Burt and D. Perrett (2001). Computer Graphics in Facial Perception Research. IEEE Computer Graphics and Applications, 21(5), 42-50.
}
}
\examples{
\donttest{
if (webmorph_up()) {
  demo_stim() |> avg()
}
}
}
\seealso{
WebMorph.org functions
\code{\link{continuum}()},
\code{\link{loop}()},
\code{\link{symmetrize}()},
\code{\link{trans}()},
\code{\link{webmorph_up}()}
}
\concept{webmorph}
