% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etox.R
\name{etox_tests}
\alias{etox_tests}
\title{Get Tests from a ETOX ID}
\usage{
etox_tests(id, verbose = TRUE)
}
\arguments{
\item{id}{character; ETOX ID}

\item{verbose}{logical; print message during processing to console?}
}
\value{
A data.frame with test results from the ETOX database.
}
\description{
Query ETOX: Information System Ecotoxicology and Environmental Quality Targets
\url{http://webetox.uba.de/webETOX/index.do} for tests
}
\note{
Before using this function, please read the disclaimer
\url{http://webetox.uba.de/webETOX/disclaimer.do}.
}
\examples{
\dontrun{
id <- get_etoxid('Triclosan')
out <- etox_tests(id)
out[ , c('Organism', 'Effect', 'Duration', 'Time_Unit',
'Endpoint', 'Value', 'Unit')]
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\seealso{
\code{\link{get_etoxid}} to retrieve ETOX IDs, \code{\link{etox_basic}} for basic information,
\code{\link{etox_targets}} for quality targets and \code{\link{etox_tests}} for test results
}

