% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdpa_url.R
\name{wdpa_url}
\alias{wdpa_url}
\title{Download URL for the World Database on Protected Areas}
\usage{
wdpa_url(x, wait = FALSE)
}
\arguments{
\item{x}{\code{character} country for desired data. This argument
can be the name of the country (e.g. \code{"Liechtenstein"}) or the
ISO-3 code for the country (e.g. \code{"LIE"}). This argument can also
be set to \code{"global"} to obtain the URL for the global dataset.}

\item{wait}{\code{logical} if data is not immediately available for download
should the session be paused until it is ready for download? If argument
to \code{wait} is \code{FALSE} and the data is not ready then an error
will be thrown. Defaults to \code{FALSE}.}
}
\value{
\code{character} URL to download the data.
}
\description{
Obtain the URL for downloading data from the World Database on Protected
Areas (WDPA).
}
\examples{
\donttest{
# obtain url for New Zealand data
nzl_url <- wdpa_url("New Zealand", wait = TRUE)
print(nzl_url)

# obtain url for New Zealand data using its ISO3 code
nzl_url <- wdpa_url("NZL", wait = TRUE)
print(nzl_url)

# obtain url for global data
global_url <- wdpa_url("global")
print(global_url)
}
}
\seealso{
\code{\link{wdpa_fetch}}, \code{\link[countrycode]{countrycode}}.
}
