% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpactl.R
\name{rpactl.newedge}
\alias{rpactl.newedge}
\title{Control new edges in each step. Defined for \code{rpanet}.}
\usage{
rpactl.newedge(
  distribution = NA,
  dparams = list(),
  shift = 1,
  snode.replace = TRUE,
  tnode.replace = TRUE,
  node.replace = TRUE
)
}
\arguments{
\item{distribution}{Distribution function for number of new edges. Default is
\code{NA}. If specified, its first argument must be the number of
observations.}

\item{dparams}{Additional parameters passed on to \code{distribution}. The
name of parameters must be specified.}

\item{shift}{A constant add to the specified distribution. Default value is
1.}

\item{snode.replace}{Logical, whether the source nodes in the same step
should be sampled with replacement. Defined for directed networks.}

\item{tnode.replace}{Logical, whether the target nodes in the same step
should be sampled with replacement. Defined for directed networks.}

\item{node.replace}{Logical, whether the nodes in the same step should be
sampled with replacement. Defined for undirected networks. If FALSE, 
self-loops will not be allowed under beta scenario.}
}
\value{
A list of class \code{rpactl} with components \code{distribution},
  \code{dparams}, \code{shift}, \code{snode.replace}, \code{tnode.replace} and 
  \code{node.replace} with meanings as explained under 'Arguments'.
}
\description{
Control new edges in each step. Defined for \code{rpanet}.
}
\examples{
control <- rpactl.newedge(distribution = rpois,
    dparams = list(lambda = 2),
    shift = 1,
    node.replace = FALSE)
}
