% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{adj_to_edge}
\alias{adj_to_edge}
\title{Convert adjacency matrix to edgelist and edgeweight.}
\usage{
adj_to_edge(adj, directed = TRUE, weighted = TRUE)
}
\arguments{
\item{adj}{Adjacency matrix of a network.}

\item{directed}{Logical, whether the network is directed. Passed to
\code{igraph::graph_from_adjacency_matrix}.}

\item{weighted}{Passed to \code{igraph::graph_from_adjacency_matrix}. This
argument specifies whether to create a weighted graph from an adjacency
matrix. If it is NULL then an unweighted graph is created and the elements
of the adjacency matrix gives the number of edges between the vertices. If
it is TRUE then a weighted graph is created and the name of the edge
attribute will be weight.}
}
\value{
A list of edgelist and edgeweight.
}
\description{
Convert adjacency matrix to edgelist and edgeweight.
}
