% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_WeatherStation.R
\name{read.WSdata}
\alias{read.WSdata}
\title{Prepares weather station data}
\usage{
read.WSdata(WSdata, ..., height = 2.2, lat, long, elev, columns = c(date =
  1, time = 2, radiation = 3, wind = 4, RH = 6, temp = 7, rain = 8),
  date.format = "\%Y-\%m-\%d", time.format = "\%H:\%M:\%S",
  datetime.format = "\%Y-\%m-\%d \%H:\%M:\%S", tz = "", cf = c(1, 1, 1),
  MTL)
}
\arguments{
\item{WSdata}{csv file with weather station data or data.frame}

\item{...}{additional parameter to pass to read.csv()}

\item{height}{weather station sensors height in meters}

\item{lat}{latitude of weather station in decimal degrees. 
Negative values for south latitude}

\item{long}{longitude of weather station in decimal degrees. 
Negative values for west longitude}

\item{elev}{elevation of weather station in meters}

\item{columns}{vector with the column numbers in WSdata for the 
date, time, radiation, wind, RH, temperature and 
rain. If date and time are in the same column, the 
column number has to be the same. Names in this
vector are ignored and are presented on Usage and 
examples only as a reference.}

\item{date.format}{date format. See strptime format argument.}

\item{time.format}{time format. See strptime format argument.}

\item{datetime.format}{datetime format. See strptime format argument.}

\item{tz}{timezone of the weather station dates. If not 
present assumes the same timezone as the computer running the code. See 
strptime for details.}

\item{cf}{conversion factor to convert radiation, wind, and 
temperature to W/m2; m/s and Celsius. See Details.}

\item{MTL}{Metadata file. If not provided will look for one on
working directory. If provided or present will calculate weather conditions
on satellite overpass.}
}
\value{
waterWeatherStation object, with data.frames with all data, hourly
data and conditions at satellite flyby.
}
\description{
Prepares weather station data
}
\details{
For cf, if your data is in W/m2, km/h and Celsius (radiation, wind, 
temperature), cf should be: cf = c(1,0.2777778,1)
}
\examples{
csvfile <- system.file("extdata", "apples.csv", package="water")
MTLfile <- system.file("extdata", "L7.MTL.txt", package="water")
WS <- read.WSdata(WSdata = csvfile, date.format = "\%d/\%m/\%Y", 
                  lat=-35.42222, long= -71.38639, elev=201, height= 2.2,
                  columns=c("date" = 1, "time" = 2, "radiation" = 3,
                  "wind" = 4, "RH" = 6, "temp" = 7, "rain" = 8), 
                  MTL = MTLfile)
print(WS)
plot(WS, alldata=FALSE)
plot(WS, alldata=TRUE)
}
\references{
Landsat 7 Metadata example file available from the U.S. Geological Survey.
Weather Station example file courtesy of CITRA, Universidad de Talca, Chile
}
\seealso{
\code{\link{read.WSdata2}} for the equivalent using read.csv2()

Other Weather station related functions: \code{\link{plot.waterWeatherStation}},
  \code{\link{print.waterWeatherStation}},
  \code{\link{read.WSdata2}}
}
\author{
Guillermo Federico Olmedo
}
