% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranova.h.R
\name{ranova}
\alias{ranova}
\title{Robust ANOVA}
\usage{
ranova(data, dep, factors = NULL, method = "trim", ph = FALSE, tr = 0.2,
  est = "mom", nboot = 599, dist = "proj")
}
\arguments{
\item{data}{the data as a data frame}

\item{dep}{a string naming the dependent variable from \code{data}; the 
variable must be numeric}

\item{factors}{a vector of strings naming the fixed factors from 
\code{data}}

\item{method}{\code{'median'}, \code{'trim'} (default) or \code{'boot'}; 
the method to use, median, trimmed means, or bootstrapped}

\item{ph}{\code{TRUE} or \code{FALSE} (default), provide post hoc tests}

\item{tr}{a number between 0 and 0.5, (default: 0.2), the proportion of 
measurements to trim from each end, when using the trim and bootstrap 
methods}

\item{est}{\code{'onestep'}, \code{'mom'} (default) or \code{'median'}, the 
M-estimator to use; One-step, Modified one-step or Median respectively}

\item{nboot}{a number (default: 599) specifying the number of bootstrap 
samples to use when using the bootstrap method}

\item{dist}{\code{'maha'} or \code{'proj'} (default), whether to use 
Mahalanobis or Projection distances respectively}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$main} \tab \tab \tab \tab \tab the table of ANOVA results \cr
  \code{results$phs} \tab \tab \tab \tab \tab the table of posthoc tests \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$main$asDF}

\code{as.data.frame(results$main)}
}
\description{
Robust Analysis of Variance
}
\examples{
data('goggles', package='WRS2')

ranova(goggles,
       dep = 'attractiveness',
       factors = c('gender', 'alcohol'),
       ph = TRUE)

#
#  ROBUST ANOVA
#
#  Robust ANOVA
#  ------------------------------------
#                      Q        p
#  ------------------------------------
#    gender             1.67    0.209
#    alcohol           48.28    0.001
#    gender:alcohol    26.26    0.001
#  ------------------------------------
#   Note. Method of trimmed means,
#   trim level 0.2
#
#
#  POST HOC TESTS
#
#  Post Hoc Tests - gender
#  --------------------------------------------------------
#                       psi-hat   p        Lower    Upper
#  --------------------------------------------------------
#    Female    Male     10.0      0.209    -6.00    26.0
#  --------------------------------------------------------
#
#
#  Post Hoc Tests - alcohol
#  -------------------------------------------------------------
#                           psi-hat   p         Lower    Upper
#  -------------------------------------------------------------
#    None       2 Pints     -3.33      0.611    -20.5     13.8
#    None       4 Pints     35.83     < .001     19.3     52.3
#    2 Pints    4 Pints     39.17     < .001     22.5     55.9
#  -------------------------------------------------------------
#

}
