% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peek.R
\name{peek}
\alias{peek}
\title{Data Frame Viewing}
\usage{
peek(x, n = 10, width = 10, ...)
}
\arguments{
\item{x}{A \code{\link[base]{data.frame}} object.}

\item{n}{Number of rows to display.}

\item{width}{The width of the columns to be displayed.}

\item{\ldots}{For internal use.}
}
\value{
Prints a truncated head but invisibly returns \code{x}.
}
\description{
Convenience function to view all the columns of the head
of a truncated \code{\link[base]{data.frame}}.  \code{peek} invisibly returns
\code{x}.  This makes its use ideal in a \pkg{dplyr}/\pkg{magrittr} pipeline.
}
\details{
By default \pkg{dplyr} does not print all columns of a data frame
(\code{tbl_df}).  This makes inspection of data difficult at times,
particularly with text string data.  \code{peek} allows the user to see a
truncated head for inspection purposes.
}
\examples{
(dat1 <- r_data_frame(100, id, sentence, paragraph))
peek(dat1)
peek(dat1, n = 20)
peek(dat1, width = 40)

library(dplyr)

## Use in a dplyr/magrittr pipeline to view the data (silly example)
par(mfrow = c(2, 2))

r_data_frame(1000, id, sex, pet, employment, eye, sentence, paragraph) \%>\%
    peek \%>\%
    (function(x, ind = 2:5){ invisible(lapply(ind, function(i) pie(table(x[[i]]))))})

## A wider data set example
dat2 <- r_data_theme()

dat2
peek(dat2)
}
\seealso{
\code{\link[utils]{head}}
}

